package data.missions.atopthemountain;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.fleet.FleetGoal;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.mission.FleetSide;
import com.fs.starfarer.api.mission.MissionDefinitionAPI;
import com.fs.starfarer.api.mission.MissionDefinitionPlugin;
import data.scripts.SWPModPlugin;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;

public class MissionDefinition implements MissionDefinitionPlugin {

    private static Vector2f getSafeSpawn(FleetSide side, float mapX, float mapY) {
        Vector2f spawnLocation = new Vector2f();

        spawnLocation.x = MathUtils.getRandomNumberInRange(-mapX / 2, mapX / 2);
        if (side == FleetSide.PLAYER) {
            spawnLocation.y = (-mapY / 2f);

        } else {
            spawnLocation.y = mapY / 2;
        }

        return spawnLocation;
    }

    @Override
    public void defineMission(MissionDefinitionAPI api) {
        api.initFleet(FleetSide.PLAYER, "", FleetGoal.ATTACK, false);
        api.initFleet(FleetSide.ENEMY, "ISA", FleetGoal.ATTACK, true);

        api.setFleetTagline(FleetSide.PLAYER, "Templar Vanguard");
        api.setFleetTagline(FleetSide.ENEMY, "Imperial Forward Defense");

        if (!SWPModPlugin.templarsExists) {
            api.addBriefingItem("THE KNIGHTS TEMPLAR REQUIRED");
            api.addBriefingItem("Download The Knights Templar to play this mission!");
        }

        if (!SWPModPlugin.imperiumExists) {
            api.addBriefingItem("INTERSTELLAR IMPERIUM REQUIRED");
            api.addBriefingItem("Download Interstellar Imperium to play this mission!");
        }

        if (!SWPModPlugin.templarsExists || !SWPModPlugin.imperiumExists) {
            return;
        } else {
            api.addBriefingItem("Defeat the blasphemers");
        }

        api.addToFleet(FleetSide.PLAYER, "tem_paladin_agi", FleetMemberType.SHIP, "Punisher", true);
        api.addToFleet(FleetSide.PLAYER, "tem_chevalier_est", FleetMemberType.SHIP, "Vindicator", false);
        api.addToFleet(FleetSide.PLAYER, "tem_crusader_def", FleetMemberType.SHIP, "Shield", false).getCaptain().setPersonality(
                "cautious");
        api.addToFleet(FleetSide.PLAYER, "tem_crusader_def", FleetMemberType.SHIP, "Aegis", false).getCaptain().setPersonality(
                "cautious");
        api.addToFleet(FleetSide.PLAYER, "tem_jesuit_ati", FleetMemberType.SHIP, "Guisarme", false).getCaptain().setPersonality(
                "cautious");
        api.addToFleet(FleetSide.PLAYER, "tem_jesuit_ati", FleetMemberType.SHIP, "Fauchard", false).getCaptain().setPersonality(
                "cautious");

        api.addToFleet(FleetSide.ENEMY, "ii_caesar_for", FleetMemberType.SHIP, "ISA Citadel", false);
        api.addToFleet(FleetSide.ENEMY, "ii_olympus_a_sta", FleetMemberType.SHIP, "ISA Armageddon", false);
        api.addToFleet(FleetSide.ENEMY, "ii_jupiter_art", FleetMemberType.SHIP, "ISA Clocktower", false);
        api.addToFleet(FleetSide.ENEMY, "ii_jupiter_mob", FleetMemberType.SHIP, "ISA Guardian", false);
        api.addToFleet(FleetSide.ENEMY, "ii_adamas_eli", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_malleus_art", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_dictator_def", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_dictator_sta", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_sebastos_ig_imp", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_sebastos_art", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_sebastos_art", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_praetorian_ig_imp", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_praetorian_ig_imp", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_legionary_sta", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_legionary_bal", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_hammerhead_i_eli", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_hammerhead_i_eli", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_decurion_ig_imp", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_decurion_ig_imp", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_maximus_bea", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_maximus_bea", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_invictus_arm", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_invictus_arm", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_basileus_str", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_basileus_str", FleetMemberType.SHIP, false);

        float width = 14000f;
        float height = 20000f;
        api.initMap(-width / 2f, width / 2f, -height / 2f, height / 2f);

        for (int i = 0; i < 8; i++) {
            float x = (float) Math.random() * width - width / 2;
            float y = (float) Math.random() * height - height / 2;
            float radius = 100f + (float) Math.random() * 400f;
            api.addNebula(x, y, radius);
        }

        api.addObjective(width * 0.4f, -height * 0.15f, "nav_buoy");
        api.addObjective(-width * 0.4f, -height * 0.15f, "sensor_array");

        api.addAsteroidField(0f, 0f, 45f, width, 20f, 70f, 250);
        //api.addPlugin(new Plugin(width, height));
    }

    private static final class Plugin extends BaseEveryFrameCombatPlugin {

        private boolean done = false;
        private final float mapX;
        private final float mapY;
        private float timer = 5f;

        private Plugin(float mapX, float mapY) {
            this.mapX = mapX;
            this.mapY = mapY;
        }

        @Override
        public void advance(float amount, List<InputEventAPI> events) {
            if (done || Global.getCombatEngine() == null || Global.getCombatEngine().isPaused()) {
                return;
            }

            timer -= amount;
            if (timer <= 0f) {
                for (FleetMemberAPI member : Global.getCombatEngine().getFleetManager(FleetSide.ENEMY).getReservesCopy()) {
                    if (!Global.getCombatEngine().getFleetManager(FleetSide.ENEMY).getDeployedCopy().contains(member)) {
                        Global.getCombatEngine().getFleetManager(FleetSide.ENEMY).spawnFleetMember(member, getSafeSpawn(
                                                                                                   FleetSide.ENEMY, mapX,
                                                                                                   mapY), 270f, 1f);
                    }
                }
                done = true;
            }
        }

        @Override
        public void init(CombatEngineAPI engine) {
        }
    }
}
